<?php
    $about = getContent('about.content', true);
    $abouts = getContent('about.element', orderById:true);
?>

<!-- About Section -->
<div class="about-section pt-100 pb-100">
  <div class="container">
      <div class="row gy-5">
          <div class="col-lg-6">
              <div class="section-header">
                  <h2 class="section-header__title"><?php echo e(__(@$about->data_values->heading)); ?></h2>
                  <h4 class="mt-4"><?php echo e(__(@$about->data_values->subheading)); ?></h4>
                  <p class="section-header__text"><?php echo e(__(@$about->data_values->description)); ?></p>
              </div>
              <a href="<?php echo e(@$about->data_values->button_url); ?>" class="btn btn--base">
                <?php echo e(__(@$about->data_values->button_text)); ?>

                <i class="las la-angle-right ms-1"></i>
            </a>

          </div>
          <div class="col-lg-6 ps-lg-5">
              <div class="section-thumb">
                  <img src="<?php echo e(frontendImage('about',@$about->data_values->image, '765x545')); ?>" alt="" class="mw-100">
              </div>
          </div>
      </div>

      <div class="row gy-4 gy-sm-5 pt-80 align-items-center justify-content-between flex-wrap-reverse">
          <div class="col-lg-4">
              <div class="section-thumb">
                  <img src="<?php echo e(frontendImage('about',@$about->data_values->second_image, '450x345')); ?>" alt="img" class="mw-100">
              </div>
          </div>
          <div class="col-lg-8 col-xl-7">
              <h3 class="pb-50"><?php echo e(__(@$about->data_values->second_heading)); ?></h3>
              <div class="row gy-sm-5 gy-4">
                <?php $__currentLoopData = $abouts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $about): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-sm-6">
                        <div class="why-list">
                            <div class="icon">
                                <?php echo @$about->data_values->icon; ?>
                            </div>
                            <div class="content">
                                <h5><?php echo e(__(@$about->data_values->title)); ?></h5>
                                <p><?php echo e(__(@$about->data_values->text)); ?></p>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </div>
          </div>
      </div>
  </div>
</div>
<!-- About Section -->
<?php /**PATH /home/burlingm/test.minfrontswing.xyz/sl/core/resources/views/templates/swap/sections/about.blade.php ENDPATH**/ ?>