<?php
    $contact = getContent('contact_us.content', true);
    $contacts = getContent('contact_us.element', orderById:true);
?>

<?php $__env->startSection('content'); ?>

<!-- Contact Section -->
<div class="contact-section pt-100 pb-100">
    <div class="container">
        <div class="row gy-4 justify-content-between">
            <div class="col-lg-5">
                <h3 class="mb-2 mb-sm-3"><?php echo e(__(@$contact->data_values->heading)); ?></h3>
                <p class="mb-3 mb-sm-4"><?php echo e(__(@$contact->data_values->subheading)); ?></p>
                <div class="row gy-lg-5 gy-4">

                    <?php $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $singleContact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-12 col-sm-6">
                        <div class="contact-info">
                            <div class="contact-info__icon">
                                <?php
                                    echo $singleContact->data_values->icon;
                                ?>
                            </div>
                            <div class="contact-info__content">
                                <h6 class="title"><?php echo e(__($singleContact->data_values->title)); ?></h6>
                                <p><?php echo e(__($singleContact->data_values->address)); ?></p>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="form-wrapper">
                    <form action="#" method="post" class="verify-gcaptcha">
                        <?php echo csrf_field(); ?>
                        <div class="form-group mb-3">
                            <label class="form-label fw-medium"><?php echo app('translator')->get('Name'); ?></label>
                            <input name="name" type="text" class="form-control form--control border-0 bg-white" value="<?php echo e(auth()->user() ? auth()->user()->fullname : old('name')); ?>" <?php echo e(auth()->user() ? 'readonly' : null); ?> required>
                        </div>
                        <div class="form-group mb-3">
                            <label class="form-label fw-medium"><?php echo app('translator')->get('Email'); ?></label>
                            <input name="email" type="email" class="form-control form--control border-0 bg-white" value="<?php echo e(auth()->user() ? auth()->user()->email : old('email')); ?>" <?php echo e(auth()->user() ? 'readonly' : null); ?> required>
                        </div>
                        <div class="form-group mb-3">
                            <label class="form-label fw-medium"><?php echo app('translator')->get('Subject'); ?></label>
                            <input name="subject" type="text" class="form-control form--control border-0 bg-white" value="<?php echo e(old('subject')); ?>" required>
                        </div>
                        <div class="form-group mb-3">
                            <label class="form-label fw-medium"><?php echo app('translator')->get('Message'); ?></label>
                            <textarea name="message" class="form-control form--control border-0 bg-white" required><?php echo e(old('message')); ?></textarea>
                        </div>

                        <div class="col-12 form-group">
                            <?php if (isset($component)) { $__componentOriginalff0a9fdc5428085522b49c68070c11d6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalff0a9fdc5428085522b49c68070c11d6 = $attributes; } ?>
<?php $component = App\View\Components\Captcha::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('captcha'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Captcha::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $attributes = $__attributesOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $component = $__componentOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__componentOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
                        </div>

                        <button type="submit" class="btn btn--base w-100 mt-2"><?php echo app('translator')->get('Submit'); ?></button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Contact Section -->

<?php if($sections->secs != null): ?>
    <?php $__currentLoopData = json_decode($sections->secs); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php echo $__env->make($activeTemplate.'sections.'.$sec, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate.'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/burlingm/test.minfrontswing.xyz/sl/core/resources/views/templates/swap/contact.blade.php ENDPATH**/ ?>