<?php
    $blog = getContent('blog.content', true);
    $blogs = getContent('blog.element', false, 3, false);
?>

<!-- Blog Section -->
<div class="section-section pt-100 pb-100">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8 col-md-10">
                <div class="section-header text-center">
                    <h2 class="section-header__title"><?php echo e(__(@$blog->data_values->heading)); ?></h2>
                    <p class="section-header__text"><?php echo e(__(@$blog->data_values->subheading)); ?></p>
                </div>
            </div>
        </div>
        <div class="row gy-4 justify-content-center">
            <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-4 col-md-6">
                    <div class="post-item">
                        <div class="post-item__thumb">
                            <img src="<?php echo e(frontendImage('blog','thumb_'.@$blog->data_values->image, '428x240')); ?>" alt="thumb" class="w-100">
                        </div>
                        <div class="post-item__content">
                            <p class="date fs--14px fw-medium mb-2"><i class="las la-calendar"></i> <?php echo e(showDateTime($blog->created_at, 'd M Y')); ?></p>
                            <h4 class="post-item__content-title">
                                <a href="<?php echo e(route('blog.details',$blog->slug)); ?>">
                                    <?php echo e(__(@$blog->data_values->title)); ?>

                                </a>
                            </h4>
                            <a href="<?php echo e(route('blog.details',$blog->slug)); ?>" class="text-decoration-underline fw-bold text--base">
                                <?php echo app('translator')->get('Read More'); ?>
                            </a>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>
<!-- Blog Section -->
<?php /**PATH /home/burlingm/test.minfrontswing.xyz/sl/core/resources/views/templates/swap/sections/blogs.blade.php ENDPATH**/ ?>