<?php
    $package = getContent('package.content', true);

    if (request()->routeIs('home')) {
        $packages = App\Models\Package::active()->take(3)->get();
    } else {
        $packages = App\Models\Package::active()->paginate(getPaginate());
    }

?>

<!-- Plan Section -->
<div class="plan-section pt-100 pb-100 position-relative overflow-hidden bg_img bg_fixed bg--light">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8 col-xxl-8">
                <div class="section-header text-center">
                    <h2 class="section-header__title"><?php echo e(__(@$package->data_values->heading)); ?></h2>
                    <p class="section-header__text"><?php echo e(__(@$package->data_values->subheading)); ?></p>
                </div>
            </div>
        </div>
        <div class="row gy-4 justify-content-center">
            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-3 col-md-6">
                    <div class="plan-item">
                        <div class="plan-item__header">
                            <h4 class="plan-name mb-3 d-flex align-items-center gap-3">
                                <span class="plan-icon"><i class="fas la-hand-point-right"></i></span>
                                <?php echo e(__($package->name)); ?>

                            </h4>
                            <h4 class="plan-price fw-semibold"><sub
                                    class="pre-sub"><?php echo e(gs('cur_sym')); ?></sub><?php echo e(showAmount($package->price, currencyFormat: false)); ?> <sub>/
                                    <?php echo app('translator')->get('Package'); ?></sub>
                            </h4>
                        </div>
                        <div class="plan-item__body">
                            <ul class="list list-style-check">
                                <?php $__currentLoopData = $package->features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="active"><?php echo e(__($feature)); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                        <div class="plan-item__footer">
                            <a href="javascript:void(0)" class="btn btn--base w-100 btn--sm text-center py-3 chooseBtn"
                                <?php if(auth()->guard()->check()): ?>
data-id="<?php echo e($package->id); ?>"
                                data-name="<?php echo e($package->name); ?>"
                                data-price="<?php echo e(showAmount($package->price, 2)); ?>"
                                data-validity="<?php echo e($package->validity); ?>" <?php endif; ?>>
                                <?php echo app('translator')->get('Choose Plan'); ?>
                            </a>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php if(!request()->routeIs('home')): ?>
                <div class="col-12">
                    <?php echo e(paginateLinks($packages)); ?>


                </div>
            <?php endif; ?>
        </div>
    </div>

</div>
<!-- Plan Section -->

<?php if(auth()->guard()->check()): ?>
    <div class="modal fade cmn--modal" id="chooseModal">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title method-name"><?php echo app('translator')->get('Are you sure to buy'); ?> <span class="modal-title-text"></span></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="<?php echo e(route('user.purchase.package')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body pt-0">
                        <div class="form-group">
                            <input type="hidden" name="id">
                        </div>
                        <ul class="list-group list-group-flush mt-3">
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo app('translator')->get('Package'); ?> <span class="packageName"></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo app('translator')->get('Price'); ?> <span class="packagePrice"></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo app('translator')->get('Validity'); ?> <span class="packageValidity"></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo app('translator')->get('Your Balance'); ?>
                                <span><?php echo e(showAmount(auth()->user()->balance)); ?> </span>
                            </li>
                        </ul>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-dark btn--sm" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <div class="prevent-double-click">
                            <button type="submit" class="btn btn--sm btn--base"><?php echo app('translator')->get('Confirm'); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php else: ?>
    <div class="modal fade cmn--modal" id="chooseModal">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content border-0">
                <div class="modal-header bg--base">
                    <h5 class="modal-title method-name text-white"><?php echo app('translator')->get('Please login before buy a package'); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p class="mb-3"><?php echo app('translator')->get('To purchase a package, you have to login into your account'); ?></p>
                    <div class="form-group">
                        <a href="<?php echo e(route('user.login')); ?>" class="btn btn--sm btn--base w-100"><?php echo app('translator')->get('Login'); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";

            $('.chooseBtn').on('click', function() {
                var modal = $('#chooseModal');

                if (<?php echo json_encode(auth()->user(), 15, 512) ?>) {
                    modal.find('.modal-title-text').text($(this).data('name'));
                    modal.find('.packageName').text($(this).data('name'));
                    modal.find('.packagePrice').text($(this).data('price') + ' ' + <?php echo json_encode(__(gs('cur_text')), 15, 512) ?>);
                    modal.find('.packageValidity').text($(this).data('validity') + ' Days');
                    modal.find('input[name=id]').val($(this).data('id'));
                }

                modal.modal('show');
            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/burlingm/test.minfrontswing.xyz/sl/core/resources/views/templates/swap/sections/package.blade.php ENDPATH**/ ?>