<?php
    $feature = getContent('feature.content', true);
    $features = getContent('feature.element', orderById:true);
?>

<!-- Feature Section -->
<div class="feature-section pt-100 pb-100">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8 col-md-10">
                <div class="section-header text-center">
                    <h2 class="section-header__title"><?php echo e(__(@$feature->data_values->heading)); ?></h2>
                    <p class="section-header__text"><?php echo e(__(@$feature->data_values->subheading)); ?></p>
                </div>
            </div>
        </div>
        <div class="feature-wrapper">
            <div class="feature-thumb d-lg-block d-none">
                <img src="<?php echo e(frontendImage('feature',@$feature->data_values->image, '840x1565')); ?>" alt="thumb" class="mw-100">
            </div>
            <div class="item-wrapper d-flex flex-wrap justify-content-between w-100">
                <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="single-item">
                        <div class="feature-item">
                            <div class="feature-item__icon">
                                <img src="<?php echo e(frontendImage('feature',@$feature->data_values->image, '128x128')); ?>" alt="icon" class="mw-100">
                            </div>
                            <div class="feature-item__content">
                                <h6 class="feature-item__content-title"><?php echo e(__(@$feature->data_values->text)); ?></h6>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</div>
<!-- Feature Section -->
<?php /**PATH /home/burlingm/test.minfrontswing.xyz/sl/core/resources/views/templates/swap/sections/feature.blade.php ENDPATH**/ ?>