<?php
    $selectedLang = $language->where('code', session('lang'))->first();
?>
<?php if(gs('enable_language')): ?>
    <div class="language dropdown">
        <button class="language-wrapper" data-bs-toggle="dropdown" aria-expanded="false">
            <div class="language-content">
                <div class="language_flag">
                    <img src="<?php echo e(getImage(getFilePath('language') . '/' . @$selectedLang->image, getFileSize('language'))); ?>"
                        alt="flag">
                </div>
                <p class="language_text_select"><?php echo e(__(@$selectedLang->name)); ?></p>
            </div>
            <span class="collapse-icon"><i class="las la-angle-down"></i></span>
        </button>
        <div class="dropdown-menu langList_dropdow py-2">
            <ul class="langList">
                <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="language-list langSel" data-code="<?php echo e($item->code); ?>">
                        <div class="language_flag">
                            <img src="<?php echo e(getImage(getFilePath('language') . '/' . $item->image, getFileSize('language'))); ?>"
                                alt="flag">
                        </div>
                        <p class="language_text"><?php echo e($item->name); ?></p>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    </div>

    <?php $__env->startPush('script'); ?>
        <script>
            (function($) {
                "use strict";
                $(".langSel").on("click", function() {
                    window.location.href = "<?php echo e(route('home')); ?>/change/" + $(this).data('code');
                });
            })(jQuery);
        </script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>


<?php $__env->startPush('style'); ?>
    <style>
        .language-wrapper {
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 12px;
            width: max-content;
            margin-left: 12px;
            padding: 0;
            background-color: transparent;
            border: 0;
        }

        .language_flag {
            flex-shrink: 0;
            display: flex;
        }

        .language_flag img {
            height: 20px;
            width: 20px;
            object-fit: cover;
            border-radius: 50%;
        }

        .language-wrapper.show .collapse-icon {
            transform: rotate(180deg)
        }

        .collapse-icon {
            font-size: 14px;
            display: flex;
            transition: all linear 0.2s;
            color: #ffffff
        }

        .language_text_select {
            font-size: 14px;
            font-weight: 400;
            color: #ffffff;
        }

        .language-content {
            display: flex;
            align-items: center;
            gap: 6px;
        }

        .language_text {
            color: #ffffff
        }

        .language-list {
            display: flex;
            align-items: center;
            gap: 6px;
            padding: 6px 12px;
            cursor: pointer;
        }

        .language .dropdown-menu {
            position: absolute;
            opacity: 0;
            visibility: hidden;
            top: 100%;
            display: unset;
            background: #2a313b;
            min-width: 150px;
            padding: 7px 0 !important;
            border-radius: 8px;
            border: 1px solid rgb(255 255 255 / 10%);
        }

        .language .dropdown-menu.show {
            visibility: visible;
            opacity: 1;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/burlingm/test.minfrontswing.xyz/sl/core/resources/views/partials/language.blade.php ENDPATH**/ ?>