<?php
    $policyPages = getContent('policy_pages.element', orderById:true);
    $socialIcons = getContent('social_icon.element', orderById:true);
    $footer = getContent('footer.content', true);
?>
<!-- Footer Section -->
<footer class="footer-section pt-50 pb-50 bg--accent">
    <div class="container">
        <div class="d-flex flex-wrap align-items-center justify-content-between footer-top gap-3">
            <a href="<?php echo e(route('home')); ?>" class="logo">
                <img src="<?php echo e(siteLogo('dark')); ?>" alt="logo">
            </a>
            <ul class="social-links d-flex flex-wrap fs--22px">
                <?php $__currentLoopData = $socialIcons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $icon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li>
                        <a href="<?php echo e($icon->data_values->url); ?>" target="_blank">
                            <?php echo $icon->data_values->social_icon; ?>
                        </a>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
        <div class="footer-bottom">
            <div class="row gy-4 gy-sm-5">
                <div class="col-lg-3 col-md-6 col-sm-6">
                    <div class="footer-widget">
                        <h4 class="footer-widget__title text-white mb-2 mb-lg-4"><?php echo app('translator')->get('Important Links'); ?></h4>
                        <ul class="links">
                            <li><a href="<?php echo e(route('packages')); ?>"><?php echo app('translator')->get('Packages'); ?></a></li>
                            <li><a href="<?php echo e(route('user.login')); ?>"><?php echo app('translator')->get('Login'); ?></a></li>
                            <li><a href="<?php echo e(route('user.register')); ?>"><?php echo app('translator')->get('Create Account'); ?></a></li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 col-sm-6">
                    <div class="footer-widget">
                        <h4 class="footer-widget__title text-white mb-2 mb-lg-4"><?php echo app('translator')->get('Information'); ?></h4>
                        <ul class="links">
                            <li><a href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('Home'); ?></a></li>
                            <li><a href="<?php echo e(route('blogs')); ?>"><?php echo app('translator')->get('Blogs'); ?></a></li>
                            <li><a href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('Contact'); ?></a></li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 col-sm-6">
                    <div class="footer-widget">
                        <h4 class="footer-widget__title text-white mb-2 mb-lg-4"><?php echo app('translator')->get('Other Links'); ?></h4>
                        <ul class="links">
                            <?php $__currentLoopData = $policyPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policyPage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <a href="<?php echo e(route('policy.pages',$policyPage->slug)); ?>">
                                        <?php echo e(__($policyPage->data_values->title)); ?>

                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 col-sm-6">
                    <div class="footer-widget">
                        <h4 class="footer-widget__title text-white mb-2 mb-lg-4"><?php echo app('translator')->get('Contact Us'); ?></h4>
                        <ul class="links">
                            <li>
                                <a href="mailto:<?php echo e(@$footer->data_values->email); ?>"><i class="las la-envelope"></i>
                                    <?php echo e(@$footer->data_values->email); ?>

                                </a>
                            </li>
                            <li><a href="tel:<?php echo e(@$footer->data_values->contact_number); ?>">
                                <i class="las la-phone-volume"></i>
                                <?php echo e(@$footer->data_values->contact_number); ?>

                            </a>
                            </li>
                            <li>
                                <p class='fs--15px mt-1 mt-sm-0 text-white'>
                                    <?php echo e(__(@$footer->data_values->address)); ?>

                                </p>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>
<!-- Footer Section -->
<?php /**PATH /home/burlingm/test.minfrontswing.xyz/sl/core/resources/views/templates/swap/partials/footer.blade.php ENDPATH**/ ?>