@extends($activeTemplate . 'layouts.' . $layout)
@section('content')
    <section class="pt-100 pb-100 bg-light">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-10">
                    <div class="custom--card">
                        <div class="card-header card-header-bg d-flex flex-wrap justify-content-between align-items-center gap-2">
                            <h5 class="card-title mt-0">
                                @php echo $myTicket->statusBadge; @endphp
                                <span class="text-white">[@lang('Ticket')#{{ $myTicket->ticket }}]
                                    {{ $myTicket->subject }}</span>
                            </h5>
                            @if ($myTicket->status != Status::TICKET_CLOSE && $myTicket->user)
                                <button class="btn btn-danger close-button btn--sm" title="@lang('Close Ticket')" data-bs-toggle="modal"
                                    data-bs-target="#closeModal">
                                    <i class="las la-times"></i>
                                </button>
                            @endif
                        </div>
                        <div class="card-body">
                            <form method="post" action="{{ route('ticket.reply', $myTicket->id) }}" enctype="multipart/form-data"
                                class="transparent-form">
                                @csrf
                                <input type="hidden" name="replayTicket" value="1">
                                <div class="row justify-content-between">
                                    <div class="col-md-12">
                                        <div class="form-group mb-3">
                                            <textarea name="message" class="form--control form-control" id="inputMessage" rows="4" cols="10" required></textarea>
                                        </div>
                                    </div>
                                </div>
                                <div class="row justify-content-between">
                                    <div class="col-md-9">
                                        <div class="row justify-content-between">
                                            <div class="col-md-11">
                                                <div class="row justify-content-between">
                                                    <div class="col-md-11">
                                                        <button type="button" class="btn btn--base btn-sm addAttachment my-2"> <i
                                                                class="fas fa-plus"></i> @lang('Add Attachment') </button>
                                                        <p class="mb-2"><span class="text--info">@lang('Max 5 files can be uploaded | Maximum upload size is ' . convertToReadableSize(ini_get('upload_max_filesize')) . ' | Allowed File Extensions: .jpg, .jpeg, .png, .pdf, .doc, .docx')</span>
                                                        </p>
                                                        <div class="row fileUploadsContainer gy-4 mb-4">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 pt-2">
                                        <button type="submit" class="btn btn--base custom-success mt-md-4 w-100">
                                            <i class="fa fa-reply"></i> @lang('Reply')
                                        </button>
                                    </div>
                                </div>
                            </form>
                            <div class="row">
                                <div class="col-md-12">
                                    @foreach ($messages as $message)
                                        @if ($message->admin_id == 0)
                                            <div class="row support-answer-wrapper radius-3 my-3 py-3 mx-2 border">
                                                <div class="col-md-3 border-right text-end">
                                                    <h5 class="my-3">{{ $message->ticket->name }}</h5>
                                                </div>
                                                <div class="col-md-9 ps-lg-4">
                                                    <p class="text-muted font-weight-bold my-3">
                                                        @lang('Posted on')
                                                        {{ $message->created_at->format('l, dS F Y @ H:i') }}</p>
                                                    <p>{{ $message->message }}</p>
                                                    @if ($message->attachments()->count() > 0)
                                                        <div class="mt-2">
                                                            @foreach ($message->attachments as $k => $image)
                                                                <a href="{{ route('ticket.download', encrypt($image->id)) }}" class="me-3"><i
                                                                        class="fa fa-file"></i>
                                                                    @lang('Attachment') {{ ++$k }} </a>
                                                            @endforeach
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                        @else
                                            <div class="row support-answer-wrapper support-answer-wrapper-admin my-3 py-3 mx-2 border bg-light">
                                                <div class="col-md-3 border-right text-right">
                                                    <h5 class="my-3">{{ $message->admin->name }}</h5>
                                                    <p class="lead text-muted">@lang('Staff')</p>
                                                </div>
                                                <div class="col-md-9">
                                                    <p class="text-muted font-weight-bold my-3">
                                                        @lang('Posted on')
                                                        {{ $message->created_at->format('l, dS F Y @ H:i') }}</p>
                                                    <p>{{ $message->message }}</p>
                                                    @if ($message->attachments()->count() > 0)
                                                        <div class="mt-2">
                                                            @foreach ($message->attachments as $k => $image)
                                                                <a href="{{ route('ticket.download', encrypt($image->id)) }}" class="me-3"><i
                                                                        class="fa fa-file"></i>
                                                                    @lang('Attachment') {{ ++$k }} </a>
                                                            @endforeach
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                        @endif
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div class="modal fade" id="closeModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form method="post" action="{{ route('ticket.close', $myTicket->id) }}">
                    @csrf
                    <input type="hidden" name="replayTicket" value="2">
                    <div class="modal-header">
                        <h5 class="modal-title"> @lang('Confirmation')!</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p>@lang('Are you sure you want to close this support ticket')?</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-dark btn--sm" data-bs-dismiss="modal">@lang('Close')</button>
                        <button type="submit" class="btn btn--base btn--sm">@lang('Confirm')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@endsection

@push('style')
    <style>
        .input-group-text:focus {
            box-shadow: none !important;
        }
    </style>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";
            var fileAdded = 0;
            $('.addAttachment').on('click', function() {
                fileAdded++;
                if (fileAdded == 5) {
                    $(this).attr('disabled', true)
                }
                $(".fileUploadsContainer").append(`
                    <div class="col-lg-6 col-md-12 removeFileInput">
                        <div class="form-group">
                            <div class="input-group">
                                <input type="file" name="attachments[]" class="form-control form--control" accept=".jpeg,.jpg,.png,.pdf,.doc,.docx" required>
                                <button type="button" class="input-group-text removeFile bg--danger border--danger"><i class="fas fa-times"></i></button>
                            </div>
                        </div>
                    </div>
                `)
            });
            $(document).on('click', '.removeFile', function() {
                $('.addAttachment').removeAttr('disabled', true)
                fileAdded--;
                $(this).closest('.removeFileInput').remove();
            });
        })(jQuery);
    </script>
@endpush
