@extends($activeTemplate . 'layouts.app')

@php
    $authImage = getContent('auth_image.content', true);
@endphp


@section('panel')
    <div class="account-section pt-60 pb-60">
        <img src="{{ frontendImage('auth_image', @$authImage->data_values->image, '1920x840') }}" alt="bg" class="accout-bg">
        <div class="account-wrapper removeBg">
            <a href="{{ route('home') }}" class="logo mb-4 justify-content-center d-flex">
                <img src="{{ siteLogo() }}" alt="logo">
            </a>
            <div class="container">
                <div class="row justify-content-center">
                    <div class="d-flex justify-content-center">
                        <div class="verification-code-wrapper">
                            <div class="verification-area">
                                <h5 class="pb-3 text-center border-bottom text-dark mb-3">@lang('Verify Mobile Number')</h5>
                                <form action="{{ route('user.verify.mobile') }}" method="POST" class="submit-form">
                                    @csrf
                                    <p class="verification-text text-dark">@lang('A 6 digit verification code sent to your mobile number') : + {{ showMobileNumber(auth()->user()->mobile) }}</p>

                                    @include($activeTemplate . 'partials.verification_code')

                                    <div class="mb-3">
                                        <button type="submit" class="btn btn--base custom-submit-btn w-100">@lang('Submit')</button>
                                    </div>

                                    <div class="mb-3">
                                        <p>
                                            @lang('If you don\'t get any code'), <span class="countdown-wrapper">@lang('try again after') <span id="countdown"
                                                    class="fw-bold">--</span> @lang('seconds')</span> <a
                                                href="{{ route('user.send.verify.code', 'sms') }}" class="try-again-link d-none"> @lang('Try again')</a>
                                        </p>
                                        <a href="{{ route('user.logout') }}">@lang('Logout')</a>
                                    </div>

                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        var distance = Number("{{ @$user->ver_code_send_at->addMinutes(2)->timestamp - time() }}");
        var x = setInterval(function() {
            distance--;
            document.getElementById("countdown").innerHTML = distance;
            if (distance <= 0) {
                clearInterval(x);
                document.querySelector('.countdown-wrapper').classList.add('d-none');
                document.querySelector('.try-again-link').classList.remove('d-none');
            }
        }, 1000);
    </script>
@endpush
