@php
    $text = isset($register) ? 'Register' : 'Login';
@endphp
@if (
    @gs('socialite_credentials')->linkedin->status ||
        @gs('socialite_credentials')->facebook->status == Status::ENABLE ||
        @gs('socialite_credentials')->google->status == Status::ENABLE)

    <div class="d-flex gap-3">
        @if (@gs('socialite_credentials')->google->status == Status::ENABLE)
            <div class="flex-fill continue-google">
                <a href="{{ route('user.social.login', 'google') }}" class="btn w-100 social-login-btn">
                    <span class="google-icon">
                        <img src="{{ asset($activeTemplateTrue . 'images/google.svg') }}" alt="Google">
                    </span>
                    <span class="social-login-btn__text">
                        @lang("Google")
                    </span>
                </a>
            </div>
        @endif
        @if (@gs('socialite_credentials')->facebook->status == Status::ENABLE)
            <div class="flex-fill continue-facebook">
                <a href="{{ route('user.social.login', 'facebook') }}" class="btn w-100 social-login-btn">
                    <span class="facebook-icon">
                        <img src="{{ asset($activeTemplateTrue . 'images/facebook.svg') }}" alt="Facebook">
                    </span>
                    <span class="social-login-btn__text">@lang("Facebook")</span>
                </a>
            </div>
        @endif
        @if (@gs('socialite_credentials')->linkedin->status == Status::ENABLE)
            <div class="flex-fill continue-facebook">
                <a href="{{ route('user.social.login', 'linkedin') }}" class="btn w-100 social-login-btn">
                    <span class="facebook-icon">
                        <img src="{{ asset($activeTemplateTrue . 'images/linkdin.svg') }}" alt="Linkedin">
                    </span>
                    <span class="social-login-btn__text">
                        @lang("Linkedin")
                    </span>
                </a>
            </div>
        @endif
    </div>
    <div class="text-center my-3">
        <span>@lang('OR')</span>
    </div>
@endif
@push('style')
    <style>
        .social-login-btn {
            color: #fff;
            border: 1px solid rgba(255, 255, 255, 0.6);
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            border-color: rgba(255, 255, 255, 0.15);
            line-height: 1;
        }


        .social-login-btn:hover,
        .social-login-btn:focus,
        .social-login-btn:focus-within {
            border-color: rgba(255, 255, 255, 1);
        }

        body.lightmode .social-login-btn{
            border-color: #c7c7c7;
            color: #000000;
        }
    </style>
@endpush
