@php
    $selectedLang = $language->where('code', session('lang'))->first();
@endphp
@if (gs('enable_language'))
    <div class="language dropdown">
        <button class="language-wrapper" data-bs-toggle="dropdown" aria-expanded="false">
            <div class="language-content">
                <div class="language_flag">
                    <img src="{{ getImage(getFilePath('language') . '/' . @$selectedLang->image, getFileSize('language')) }}"
                        alt="flag">
                </div>
                <p class="language_text_select">{{ __(@$selectedLang->name) }}</p>
            </div>
            <span class="collapse-icon"><i class="las la-angle-down"></i></span>
        </button>
        <div class="dropdown-menu langList_dropdow py-2">
            <ul class="langList">
                @foreach ($language as $item)
                    <li class="language-list langSel" data-code="{{ $item->code }}">
                        <div class="language_flag">
                            <img src="{{ getImage(getFilePath('language') . '/' . $item->image, getFileSize('language')) }}"
                                alt="flag">
                        </div>
                        <p class="language_text">{{ $item->name }}</p>
                    </li>
                @endforeach
            </ul>
        </div>
    </div>

    @push('script')
        <script>
            (function($) {
                "use strict";
                $(".langSel").on("click", function() {
                    window.location.href = "{{ route('home') }}/change/" + $(this).data('code');
                });
            })(jQuery);
        </script>
    @endpush
@endif


@push('style')
    <style>
        .language-wrapper {
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 12px;
            width: max-content;
            margin-left: 12px;
            padding: 0;
            background-color: transparent;
            border: 0;
        }

        .language_flag {
            flex-shrink: 0;
            display: flex;
        }

        .language_flag img {
            height: 20px;
            width: 20px;
            object-fit: cover;
            border-radius: 50%;
        }

        .language-wrapper.show .collapse-icon {
            transform: rotate(180deg)
        }

        .collapse-icon {
            font-size: 14px;
            display: flex;
            transition: all linear 0.2s;
            color: #ffffff
        }

        .language_text_select {
            font-size: 14px;
            font-weight: 400;
            color: #ffffff;
        }

        .language-content {
            display: flex;
            align-items: center;
            gap: 6px;
        }

        .language_text {
            color: #ffffff
        }

        .language-list {
            display: flex;
            align-items: center;
            gap: 6px;
            padding: 6px 12px;
            cursor: pointer;
        }

        .language .dropdown-menu {
            position: absolute;
            opacity: 0;
            visibility: hidden;
            top: 100%;
            display: unset;
            background: #2a313b;
            min-width: 150px;
            padding: 7px 0 !important;
            border-radius: 8px;
            border: 1px solid rgb(255 255 255 / 10%);
        }

        .language .dropdown-menu.show {
            visibility: visible;
            opacity: 1;
        }
    </style>
@endpush
